<style>
    :root {
        --primary-color: #f26124;
        --secondary-color: #231f20;
        --success-green: #28a745;
        --info-blue: #17a2b8;
        --danger-red: #dc3545;
        --warning-yellow: #ffc107;
    }

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        background: #f4f6f9;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        color: #495057;
    }

    /* Container */
    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 15px;
    }

    /* Spacing */
    .py-5 {
        padding-top: 3rem !important;
        padding-bottom: 3rem !important;
    }

    .mb-1 {
        margin-bottom: 0.25rem !important;
    }

    .mb-2 {
        margin-bottom: 0.5rem !important;
    }

    .mb-3 {
        margin-bottom: 1rem !important;
    }

    .mb-4 {
        margin-bottom: 1.5rem !important;
    }

    .mt-5 {
        margin-top: 3rem !important;
    }

    .p-4 {
        padding: 1.5rem !important;
    }

    /* Grid */
    .row {
        display: flex;
        flex-wrap: wrap;
        gap: 24px;
    }

    .col-lg-3 {
        flex: 0 0 calc(25% - 18px);
    }

    .col-md-4 {
        flex: 0 0 calc(33.333% - 16px);
    }

    .col-sm-6 {
        flex: 0 0 calc(50% - 12px);
    }

    .text-center {
        text-align: center;
    }

    /* Typography */
    h3 {
        font-size: 28px;
        font-weight: 700;
        color: #231f20;
        margin-bottom: 0.5rem;
    }

    h4 {
        font-size: 20px;
        font-weight: 700;
        color: #231f20;
    }

    h5 {
        font-size: 16px;
        font-weight: 700;
        color: #231f20;
        margin: 0;
    }

    p {
        font-size: 14px;
        color: #495057;
        margin: 0;
    }

    .lead {
        font-size: 18px;
        font-weight: 300;
        color: #6c757d;
    }

    .fw-bold {
        font-weight: 700;
    }

    .text-muted {
        color: #6c757d !important;
    }

    .text-white {
        color: #fff !important;
    }

    .small {
        font-size: 12px;
    }

    /* Cards */
    .card {
        background: #fff;
        border-radius: 12px;
        border: none;
        overflow: hidden;
        transition: all 0.3s ease;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .card:hover {
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.12);
        transform: translateY(-5px);
    }

    .card-body {
        padding: 1.5rem;
    }

    .h-100 {
        height: 100%;
    }

    .border-0 {
        border: none !important;
    }

    .shadow-sm {
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    /* Images */
    .rounded-circle {
        border-radius: 50%;
        object-fit: cover;
    }

    .d-inline-flex {
        display: inline-flex;
    }

    .align-items-center {
        align-items: center;
    }

    .justify-content-center {
        justify-content: center;
    }

    /* Volunteer Card Styling */
    .volunteer-card {
        background: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
        border: none;
        transition: all 0.3s ease;
        overflow: hidden;
    }

    .volunteer-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 12px 24px rgba(0, 0, 0, 0.15);
    }

    .volunteer-card .card-body {
        padding: 1.5rem;
    }

    .volunteer-card img {
        width: 120px;
        height: 120px;
        object-fit: cover;
        border: 4px solid #f0f0f0;
        transition: all 0.3s ease;
    }

    .volunteer-card:hover img {
        border-color: var(--primary-color);
    }

    .bg-primary {
        background-color: var(--primary-color) !important;
    }

    /* Icons */
    i {
        margin-right: 4px;
        transition: all 0.2s ease;
    }

    .fa-4x {
        font-size: 4em;
    }

    .fa-map-marker-alt {
        color: var(--primary-color);
    }

    /* Buttons */
    .btn {
        font-size: 14px;
        font-weight: 600;
        padding: 10px 16px;
        border-radius: 6px;
        transition: all 0.3s ease;
        border: none;
        cursor: pointer;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }

    .btn-primary {
        background: var(--primary-color);
        color: #fff;
    }

    .btn-primary:hover {
        background: #d95520;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(242, 97, 36, 0.3);
        color: #fff;
        text-decoration: none;
    }

    .btn-lg {
        padding: 12px 20px;
        font-size: 16px;
    }

    /* Empty State */
    .empty-state-icon {
        font-size: 64px;
        color: #dee2e6;
        margin-bottom: 1.5rem;
        display: inline-block;
    }

    /* Responsive */
    @media (max-width: 1200px) {
        .col-lg-3 {
            flex: 0 0 calc(25% - 18px);
        }

        .row {
            gap: 20px;
        }
    }

    @media (max-width: 992px) {
        .col-lg-3 {
            flex: 0 0 calc(33.333% - 16px);
        }

        .col-md-4 {
            flex: 0 0 calc(33.333% - 16px);
        }

        .row {
            gap: 16px;
        }

        h3 {
            font-size: 24px;
        }

        .lead {
            font-size: 16px;
        }
    }

    @media (max-width: 768px) {
        .col-lg-3 {
            flex: 0 0 calc(50% - 12px);
        }

        .col-md-4 {
            flex: 0 0 calc(50% - 12px);
        }

        .col-sm-6 {
            flex: 0 0 calc(50% - 12px);
        }

        .py-5 {
            padding-top: 2rem !important;
            padding-bottom: 2rem !important;
        }

        .mt-5 {
            margin-top: 2rem !important;
        }

        .card-body {
            padding: 1rem;
        }

        h3 {
            font-size: 20px;
        }

        h4 {
            font-size: 18px;
        }

        h5 {
            font-size: 14px;
        }

        .lead {
            font-size: 14px;
        }

        .btn-lg {
            padding: 10px 16px;
            font-size: 14px;
        }

        .volunteer-card img {
            width: 100px;
            height: 100px;
        }

        .volunteer-card .card-body {
            padding: 1rem;
        }
    }

    @media (max-width: 576px) {
        .col-lg-3 {
            flex: 0 0 100%;
        }

        .col-md-4 {
            flex: 0 0 100%;
        }

        .col-sm-6 {
            flex: 0 0 100%;
        }

        .container {
            padding: 0 10px;
        }

        .py-5 {
            padding-top: 1.5rem !important;
            padding-bottom: 1.5rem !important;
        }

        .mt-5 {
            margin-top: 1.5rem !important;
        }

        .card {
            margin-bottom: 1rem;
        }

        .card-body {
            padding: 0.75rem;
        }

        h3 {
            font-size: 18px;
        }

        h4 {
            font-size: 16px;
        }

        h5 {
            font-size: 13px;
        }

        p {
            font-size: 12px;
        }

        .lead {
            font-size: 13px;
        }

        .btn {
            padding: 8px 12px;
            font-size: 12px;
            width: 100%;
            justify-content: center;
        }

        .btn-lg {
            padding: 10px 12px;
            font-size: 12px;
        }

        .fa-4x {
            font-size: 3em;
        }

        .volunteer-card img {
            width: 80px;
            height: 80px;
        }

        .volunteer-card .card-body {
            padding: 0.75rem;
        }

        .empty-state-icon {
            font-size: 48px;
        }
    }
</style>

<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<div class="container py-5">
    <?php if (!empty($volunteers)): ?>
        <div class="row">
            <?php foreach ($volunteers as $volunteer): ?>
                <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                    <div class="card h-100 shadow-sm border-0 text-center volunteer-card">
                        <div class="card-body p-4">
                            <?php if (!empty($volunteer->profile_photo)): ?>
                                <img src="<?php echo base_url('uploads/volunteers/' . $volunteer->profile_photo); ?>" 
                                     class="rounded-circle mb-3" 
                                     alt="<?php echo htmlspecialchars($volunteer->full_name); ?>"
                                     style="width: 120px; height: 120px; object-fit: cover; border: 4px solid #f0f0f0;">
                            <?php else: ?>
                                <div class="rounded-circle bg-primary d-inline-flex align-items-center justify-content-center mb-3" 
                                     style="width: 120px; height: 120px; border: 4px solid #f0f0f0;">
                                    <span class="text-white" style="font-size: 3rem;">
                                        <?php echo strtoupper(substr($volunteer->full_name, 0, 1)); ?>
                                    </span>
                                </div>
                            <?php endif; ?>
                            
                            <h5 class="fw-bold mb-1"><?php echo htmlspecialchars($volunteer->full_name); ?></h5>
                            
                            <?php if (!empty($volunteer->occupation)): ?>
                                <p class="text-muted small mb-2"><?php echo htmlspecialchars($volunteer->occupation); ?></p>
                            <?php endif; ?>
                            
                            <?php if (!empty($volunteer->city)): ?>
                                <p class="text-muted small">
                                    <i class="fas fa-map-marker-alt"></i> <?php echo htmlspecialchars($volunteer->city); ?>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="text-center py-5">
            <div class="empty-state-icon">
                <i class="fas fa-users"></i>
            </div>
            <h4 class="text-muted">No Volunteers Yet</h4>
            <p class="text-muted">Be the first to join our volunteer team!</p>
        </div>
    <?php endif; ?>
    
    <div class="text-center mt-5">
        <h3 class="fw-bold mb-3">Want to Join Our Team?</h3>
        <p class="lead text-muted mb-4">Become a part of our volunteer community</p>
        <a href="<?php echo base_url('volunteer/apply'); ?>" class="btn btn-primary btn-lg">
            <i class="fas fa-hands-helping"></i> Apply Now
        </a>
    </div>
</div>